<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Creates Use list of selected Class -->
	<xsl:template name="ClassUse">
		<xsl:param name="class"></xsl:param>
		
		<html>
		<head>
			<xsl:call-template name="ImportCSS"/>
		<title>
		<xsl:value-of select="$title_param"></xsl:value-of>
		</title>
		<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
		<xsl:call-template name="ImgLoaderScript"/>
		</head>

		<!-- NAVBAR -->
		<xsl:if test="$navbar_param">
			<xsl:call-template name="ClassUseNavBar">
				<xsl:with-param name="header" select="'true'"></xsl:with-param>
				<xsl:with-param name="class" select="$class"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<hr/>
		
		<xsl:variable name="className">
			<xsl:call-template name="classifierShortName">
				<xsl:with-param name="class" select="$class"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<center>
		<h2>
		<b>
		<xsl:variable name="title">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'uses_of_class'"></xsl:with-param>
				<xsl:with-param name="p1" select="$className"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:value-of select="$title"></xsl:value-of>		
		<br/>
		</b>
		</h2>
		</center>
		<xsl:choose>
			<xsl:when test="$class/Uses/Use">
				<xsl:call-template name="PrintUse">
					<xsl:with-param name="class" select="$class"></xsl:with-param>
					<xsl:with-param name="nodeset" select="$class/Uses/Use"></xsl:with-param>
					<xsl:with-param name="types" select="$class/Uses/Use/@type"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'no_use'"></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>

		<!-- NAVBAR -->
		<hr/>
		<xsl:if test="$navbar_param">
			<xsl:call-template name="ClassUseNavBar">
				<xsl:with-param name="class" select="$class"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<br/>
		<p/>
		<xsl:value-of select="$bottom_param"></xsl:value-of>
		</html>
	</xsl:template>
	
	<xsl:template match="Classifier" mode="getClassUsePath">
		<xsl:variable name="parentsNodeSet" select="ancestor::Package | ancestor::Classifier"/>
		<xsl:variable name="parentPath">
			<xsl:for-each select="$parentsNodeSet">
				<xsl:choose>
					<xsl:when test="name()='Classifier'">
						<xsl:text>class-use/</xsl:text>
						<xsl:value-of select="@name"/>
						<xsl:text>.</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@name"/>
						<xsl:text>/</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="relPath">
			<xsl:choose> 
				<xsl:when test="string-length($parentPath)=0"><xsl:value-of select="concat(@name, '.html')"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="concat($parentPath, @name, '.html')"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable> 
		<xsl:variable name="fullPath" select="concat($outdir, '/', $relPath)"/>
		<xsl:value-of select="$fullPath"/>
	</xsl:template>
	
	<!-- Prints Use Tables depend on types of use -->
	<xsl:template name="PrintUse">
		<xsl:param name="class"></xsl:param>
		<xsl:param name="nodeset"></xsl:param>
		<xsl:param name="types"></xsl:param>
	
		<xsl:variable name="first" select="$types[1]"></xsl:variable>
		<xsl:if test="$first">
			<xsl:variable name="stringType" select="string($first)"></xsl:variable>
	
			<xsl:call-template name="PrintUseTable">
				<xsl:with-param name="class" select="$class"></xsl:with-param>
				<xsl:with-param name="type" select="$stringType"></xsl:with-param>
				<xsl:with-param name="nodeSet" select="$class/Uses/Use[@type=$stringType]"/>
			</xsl:call-template>

			<xsl:call-template name="PrintUse">
				<xsl:with-param name="class" select="$class"></xsl:with-param>
				<xsl:with-param name="nodeset" select="$nodeset"></xsl:with-param>
				<xsl:with-param name="types" select="$types[not(string($stringType)=string(.))]"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	
	
</xsl:stylesheet>
